#include <Keypad.h>
#include <LiquidCrystal.h>

LiquidCrystal lcd(32, 30, 28, 26, 24, 22);//change the pins

const byte ROWS = 4; 
const byte COLS = 3; 
// Define the Keymap
char keys[ROWS][COLS] = {
  {'1','2','3'},
  {'4','5','6'},
  {'7','8','9'},
  {'*','0','#'}
};
// Connect keypad ROW0, ROW1, ROW2 and ROW3 to these Arduino pins.
byte rowPins[ROWS] = { 37, 39, 41, 43 };
// Connect keypad COL0, COL1 and COL2 to these Arduino pins.
byte colPins[COLS] = { 31, 33, 35 }; 
// Create the Keypad
Keypad kpd = Keypad( makeKeymap(keys), rowPins, colPins, ROWS, COLS );

// set default and maximum temperature
//int default_temperature = 200;
int maximum_temperature = 300; //set this after measurement
int set_temp = 0;
int ent_temp = 0;
int temperature;

//internal monitor flags
char flag1 = 1;
char flag2 = 1;
char flag3 = 1;
char flag4 = 1;
int flag5 = 3;
char flag6 = 1;
int start = 0;

//sensor variables
int sensorpin = A1;
int sensorvalue = 0;

//output variables
int heater_pin = 9;
int motor_pin = 10;

int temp_plastic1 = 120;//plastic 1 temperature
int temp_plastic2 = 150;//plastic 2 temperature
int temp_plastic3 = 203;//plastic 3 temperature
int temp_plastic4 = 204;//plastic 4 temperature
int temp_plastic5 = 205;//plastic 5 temperature
int temp_plastic6 = 206;//plastic 6 temperature
int temp_plastic7 = 207;//plastic 7 temperature
int temp_plastic8 = 208;//plastic 8 temperature
int temp_plastic9 = 209;//plastic 9 temperature
int temp_plastic10 = 210;//plastic 10 temperature

char string1[ ] = "RecycleBot v2.3";
char string2[ ] = "Developed by";
char string3[ ] = "Ankit Vora and"; 
char string4[ ] = "Dr. J. M. Pearce";
char string5[ ] = "1-Select Plastic";
char string6[ ] = "2-Enter Temp. ";
char string7[ ] = "Overflow (> xxx)";
char string8[ ] = "Enter Temp. <xxx";
//char string9[ ] = "Emergency stop";
char string10[ ] = "                ";
char string11[ ] = "Select type of";
char string12[ ] = "Plastic (0-9)";
char string13[ ] = "Plastic 1";
char string14[ ] = "Plastic 2";
char string15[ ] = "Plastic 3";
char string16[ ] = "Plastic 4";
char string17[ ] = "Plastic 5";
char string18[ ] = "Plastic 6";
char string19[ ] = "Plastic 7";
char string20[ ] = "Plastic 8";
char string21[ ] = "Plastic 9";
char string22[ ] = "Plastic 10";
char string23[ ] = "Set Temp.";
char string24[ ] = "Sys Temp.";

void keypad_set_temperature()
{
lcd.clear();
while(flag1 != 0)
	{
        lcd.setCursor(0, 0);
	lcd.print(string5);
	lcd.setCursor(0, 1);
	lcd.print(string6);
	char key = kpd.getKey();
	if(key)
		{
		switch (key)
			{
			case '1':
				keypad_plastic();
				flag1 = 0;
				break;
			case '2':
                                keypad_temperature();					
                                flag1 = 0;
				break;
			}
		}
	}
flag1 = 1;
while(flag6 != 0)
	{
        char key3 = kpd.getKey();
	if(key3 == '#')  
                {
                start = 1;
                flag6 = 0;
                }
        }
flag6 = 1;
}

void keypad_plastic()
{
lcd.clear();
lcd.setCursor(0, 0);
lcd.print(string11);
lcd.setCursor(0, 1);
lcd.print(string12);
while(flag2 != 0)
	{
	char key1 = kpd.getKey();
	if(key1)
		{
		switch (key1)
			{
			case '1':
				set_temp = temp_plastic1;
				lcd.clear();
				lcd.setCursor(0, 0);
				lcd.print(string13);
				lcd.setCursor(0, 1);
				lcd.print(string23);
				lcd.setCursor(10, 1);
				lcd.print(temp_plastic1);
                                flag2 = 0;
				break;
			case '2':
				set_temp = temp_plastic2;
				lcd.clear();
				lcd.setCursor(0, 0);
				lcd.print(string14);
				lcd.setCursor(0, 1);
				lcd.print(string23);
				lcd.setCursor(10, 1);
				lcd.print(temp_plastic2);
				flag2 = 0;
				break;
			case '3':
				set_temp = temp_plastic3;
				lcd.clear();
				lcd.setCursor(0, 0);
				lcd.print(string15);
				lcd.setCursor(0, 1);
				lcd.print(string23);
				lcd.setCursor(10, 1);
				lcd.print(temp_plastic3);
				flag2 = 0;
				break;
			case '4':
				set_temp = temp_plastic4;
				lcd.clear();
				lcd.setCursor(0, 0);
				lcd.print(string16);
				lcd.setCursor(0, 1);
				lcd.print(string23);
				lcd.setCursor(10, 1);
				lcd.print(temp_plastic4);
				flag2 = 0;
				break;
			case '5':
				set_temp = temp_plastic5;
				lcd.clear();
				lcd.setCursor(0, 0);
				lcd.print(string17);
				lcd.setCursor(0, 1);
				lcd.print(string23);
				lcd.setCursor(10, 1);
				lcd.print(temp_plastic5);
				flag2 = 0;
				break;
			case '6':
				set_temp = temp_plastic6;
				lcd.clear();
				lcd.setCursor(0, 0);
				lcd.print(string18);
				lcd.setCursor(0, 1);
				lcd.print(string23);
				lcd.setCursor(10, 1);
				lcd.print(temp_plastic6);
				flag2 = 0;
				break;
			case '7':
				set_temp = temp_plastic7;
				lcd.clear();
				lcd.setCursor(0, 0);
				lcd.print(string19);
				lcd.setCursor(0, 1);
				lcd.print(string23);
				lcd.setCursor(10, 1);
				lcd.print(temp_plastic7);
				flag2 = 0;
				break;
			case '8':
				set_temp = temp_plastic8;
				lcd.clear();
				lcd.setCursor(0, 0);
				lcd.print(string20);
				lcd.setCursor(0, 1);
				lcd.print(string23);
				lcd.setCursor(10, 1);
				lcd.print(temp_plastic8);
				flag2 = 0;
				break;
			case '9':
				set_temp = temp_plastic9;
				lcd.clear();
				lcd.setCursor(0, 0);
				lcd.print(string21);
				lcd.setCursor(0, 1);
				lcd.print(string23);
				lcd.setCursor(10, 1);
				lcd.print(temp_plastic9);
				flag2 = 0;
				break;
			case '0':
				set_temp = temp_plastic10;
				lcd.clear();
				lcd.setCursor(0, 0);
				lcd.print(string22);
				lcd.setCursor(0, 1);
				lcd.print(string23);
				lcd.setCursor(10, 1);
				lcd.print(temp_plastic10);
				flag2 = 0;
				break;
			}
		}
	}
flag2 = 1;
}

void keypad_temperature()
{
lcd.clear();
lcd.print(string8);
lcd.setCursor(0, 1);
while(flag3 != 0)
        {
        char key2 = kpd.getKey();
	if(key2)
		{
		switch (key2)
			{
			case '*':	//to clear the values
				lcd.setCursor(0, 1);
				lcd.print("000");
                                lcd.setCursor(0, 1);
                                lcd.print(string10);
                                lcd.setCursor(0, 1);
				ent_temp = 0;
				flag5 = 3;
				break;
			case '#':	//to confirm the values
				if((flag5 == 0) && (ent_temp <= maximum_temperature))
					{							
					lcd.setCursor(0, 1);
					lcd.print(string10);
                                        lcd.setCursor(0, 1);
					lcd.print(string23);
					set_temp = ent_temp;
					lcd.setCursor(10, 1);
					lcd.print(set_temp);
					flag5 = 3;
					flag3 = 0;
					}
				if((flag5 == 0) && (ent_temp > maximum_temperature))
					{							
					lcd.print(string10);
					lcd.setCursor(0, 1);
					lcd.print(string7);
                                        delay(1000);
                                        lcd.setCursor(0, 1);
                                        lcd.print(string10);
                                        lcd.setCursor(0, 1);
					ent_temp = 0;
					flag5 = 3;
					flag3 = 1;
					}							
				break;
			case '0':
				if(flag5 > 0)
					{
					lcd.print('0');
                                        if(flag5 == 3)
                                        	ent_temp = 0 * 100 + ent_temp; 
                                        if(flag5 == 2)
                                        	ent_temp = 0 * 10  + ent_temp;
                                        if(flag5 == 1)
                                        	ent_temp = 0 * 1   + ent_temp;
					flag5--;
					}
					break;
			case '1':
				if(flag5 > 0)
					{
					lcd.print('1');
                                        if(flag5 == 3)
                                        	ent_temp = 1 * 100 + ent_temp; 
                                        if(flag5 == 2)
                                        	ent_temp = 1 * 10  + ent_temp;
                                        if(flag5 == 1)
                                        	ent_temp = 1 * 1   + ent_temp;
					flag5--;
					}
				break;
			case '2':
				if(flag5 > 0)
					{
					lcd.print('2');
                                        if(flag5 == 3)
                                        	ent_temp = 2 * 100 + ent_temp; 
                                        if(flag5 == 2)
                                        	ent_temp = 2 * 10  + ent_temp;
                                        if(flag5 == 1)
                                        	ent_temp = 2 * 1   + ent_temp;
					flag5--;
					}
				break;
			case '3':
				if(flag5 > 0)
					{
					lcd.print('3');
                                        if(flag5 == 3)
                                        	ent_temp = 3 * 100 + ent_temp; 
                                        if(flag5 == 2)
                                        	ent_temp = 3 * 10  + ent_temp;
                                        if(flag5 == 1)
                                        	ent_temp = 3 * 1   + ent_temp;
					flag5--;
					}
				break;
			case '4':
				if(flag5 > 0)
					{
					lcd.print('4');
                                        if(flag5 == 3)
                                        	ent_temp = 4 * 100 + ent_temp; 
                                        if(flag5 == 2)
                                        	ent_temp = 4 * 10  + ent_temp;
                                        if(flag5 == 1)
                                        	ent_temp = 4 * 1   + ent_temp;
					flag5--;
					}
				break;
			case '5':
				if(flag5 > 0)
					{
					lcd.print('5');
                                        if(flag5 == 3)
                                        	ent_temp = 5 * 100 + ent_temp; 
                                        if(flag5 == 2)
                                        	ent_temp = 5 * 10  + ent_temp;
                                        if(flag5 == 1)
                                        	ent_temp = 5 * 1   + ent_temp;
					flag5--;
					}
				break;
			case '6':
				if(flag5 > 0)
					{
					lcd.print('6');
                                        if(flag5 == 3)
                                        	ent_temp = 6 * 100 + ent_temp; 
                                        if(flag5 == 2)
                                        	ent_temp = 6 * 10  + ent_temp;
                                        if(flag5 == 1)
                                        	ent_temp = 6 * 1   + ent_temp;
					flag5--;
					}
				break;
			case '7':
				if(flag5 > 0)
					{
					lcd.print('7');
                                        if(flag5 == 3)
                                        	ent_temp = 7 * 100 + ent_temp; 
                                        if(flag5 == 2)
                                        	ent_temp = 7 * 10  + ent_temp;
                                        if(flag5 == 1)
                                        	ent_temp = 7 * 1   + ent_temp;
					flag5--;
					}
				break;
			case '8':
				if(flag5 > 0)
					{
					lcd.print('8');
                                        if(flag5 == 3)
                                        	ent_temp = 8 * 100 + ent_temp; 
                                        if(flag5 == 2)
                                        	ent_temp = 8 * 10  + ent_temp;
                                        if(flag5 == 1)
                                        	ent_temp = 8 * 1   + ent_temp;
					flag5--;
					}
				break;
			case '9':
				if(flag5 > 0)
					{
					lcd.print('9');
                                        if(flag5 == 3)
                                        	ent_temp = 9 * 100 + ent_temp; 
                                        if(flag5 == 2)
                                        	ent_temp = 9 * 10  + ent_temp;
                                        if(flag5 == 1)
                                        	ent_temp = 9 * 1   + ent_temp;
					flag5--;
					}
				break;
			}
		}
        }
flag3 = 1;
}

void temperature_control()
{
int c = 0;
int pwm1 = 0;
int pwm2 = 0;
lcd.clear();
lcd.print(string23);
lcd.setCursor(10, 0);
lcd.print(set_temp);
while(flag4 != 0)
	{
        temperature_sensor();
        if(c == 1000)
                {
                lcd.setCursor(0, 1);
	        lcd.print(string10);
                lcd.setCursor(0, 1);
	        lcd.print(string24);
	        lcd.setCursor(10, 1);
	        lcd.print("   ");
	        lcd.setCursor(10, 1);
                if(temperature < 100)
                        {
                        lcd.print('0');
                        lcd.print(temperature);
                        c = 0;
                        }
                else
	                {
                        lcd.print(temperature);
                        c = 0;
                        }
                }
        if((temperature <= (set_temp - 15)) && (start == 1))
                {
                digitalWrite(heater_pin, HIGH);
                digitalWrite(motor_pin, LOW);
                }
        if((temperature >= (set_temp - 15)) && (temperature <= (set_temp)) && (start == 1))
                {
                if(pwm1 <= 250)
			{
			digitalWrite(heater_pin, HIGH); //50% PWM cycle
			}
                if((pwm1 > 250) && (pwm1 < 500))
			{
			digitalWrite(heater_pin, LOW); //50% PWM cycle
			}
                if(pwm1 == 500)
			{
			pwm1 = 0;
			}						
                digitalWrite(motor_pin, HIGH);
                }    
        if((temperature >= (set_temp)) && (temperature <= (set_temp + 15)) && (start == 1))
                {
                if(pwm2 <= 150)
			{
			digitalWrite(heater_pin, HIGH); //30% PWM cycle
			}
                if((pwm2 > 150) && (pwm2 < 500))
			{
			digitalWrite(heater_pin, LOW); //30% PWM cycle
			}
                if(pwm2 == 500)
			{
			pwm2 = 0;
			}	
                digitalWrite(motor_pin, HIGH);
                }                	
        if((temperature > (set_temp + 15)) && (start == 1))
                {
                digitalWrite(heater_pin, LOW);
                digitalWrite(motor_pin, HIGH);
                }
	c++;
	pwm1++;
	pwm2++;
        }
flag4 = 1;
start = 0;
digitalWrite(heater_pin, LOW);
digitalWrite(motor_pin, LOW);
}

void temperature_sensor()
{
sensorvalue = analogRead(sensorpin); 
temperature  = ( 5 * sensorvalue * 100.0) / 1024.0;
/*Serial.print("Celsius: ");
Serial.println(temperature);*/
}

void setup()
{
//Serial.begin(9600);
pinMode(heater_pin, OUTPUT);
pinMode(motor_pin, OUTPUT);
lcd.begin(16, 2);
lcd.print(string1);
lcd.setCursor(0, 1);
lcd.print(string2);
delay(500);  
lcd.clear();
lcd.print(string3);
lcd.setCursor(0, 1);
lcd.print(string4);
delay(500);  
lcd.clear();
}

void loop()
{
keypad_set_temperature();
temperature_control();
}
